Attribute VB_Name = "MdlVariable"
Option Explicit

'*****************************************************
' Orthogonalization coordinates display information
'*****************************************************
Public Type struct_Rectangular_coordinate
    points As Integer           'Number of points
    ViewX As Single             'X frame
    ViewY As Single             'Y frame
    VYoff As Single             'Offset direction of Y
    DeltX As Single             'Width between points in direction of X
    Color1 As Long              'Frame Color1
    Color2 As Long              'Frame Color2
End Type

'*****************************************************
' Circle coordinates display information
'*****************************************************
Public Type struct_Circle_coordinate
    points As Integer           'Number of points
    ViewX As Single             'X frame
    ViewY As Single             'Y frame
    HanX As Single              'Circle radius
    HanY As Single              'Circle radius
    CenX As Single              'Circle center X
    CenY As Single              'Circle center Y
    Color1 As Long              'Frame Color1
    Color2 As Long              'Frame Color2
End Type
'*****************************************************
'  Scale struct
'*****************************************************
Public Type Scale_t
    ref As Single               'REF VALUE
    div As Single               '/DIV
    pos As Single               'REF POSITION
End Type
'*****************************************************
'  Standard Cal Setting struct
'*****************************************************
Public Type structStdCKit
    opRs As Double              ' Open  Impedance   Rs [ohm]
    opLs As Double              ' Open  Impedance   Ls [H]
    opCp As Double              ' Open  Capacitance Cp [F]
    shRs As Double              ' Short Impedance   Rs [ohm]
    shLs As Double              ' Short Impedance   Ls [H]
    shCp As Double              ' Short Capacitance Cp [F]
    loRs As Double              ' Load  Impedance   Rs [ohm]
    loLs As Double              ' Load  Impedance   Ls [H]
    loCp As Double              ' Load  Capacitance Cp [F]
End Type
'*****************************************************
'  Cal Setting struct
'*****************************************************
Public Type structCKit
    CKitType As Long            'Cal TypeiN50,N75...j
    PortSex As Long             'Port Connect Sex Type
    UserDef As CkitUser         'Port Cal Factor
End Type
'*****************************************************
'  Marker information on each channel
'*****************************************************
Public Type structMkrChInf
    MkrActive   As Integer      'Currently Marker Active No.
    MkrTotalcnt As Integer      'Each channel total marker count
    MkrMaxPoint As Integer      'Max Measurement Point
    MkrMinPoint As Integer      'Min Measurement Point
    MkrMaxFreq  As Double       'Max Frequency
    MkrMinFreq  As Double       'Min Frequency
End Type
'*****************************************************
'  Marker Setting struct
'*****************************************************
Public Type structMkrInf
    MkrDispFlag As Integer      'Currently Marker Display Flag.
    MkrReference As Integer     'Currently Marker Reference ahead.(0:point, 1:freq)
    MkrPoint As Integer         'Currently Marker Point position.
    MkrFreq As Double           'Currently Marker Frequency
    MkrDispPosi As Integer      'Currently Marker Point is display conversion of frequency.
End Type
'*****************************************************
'  Marker Display Key word.
'*****************************************************
Public Const MKR_NOT_DISP As Integer = 0                'Marker Not Display flag.
Public Const MKR_DISPLAY  As Integer = 1                'Marker Display flag.
'*****************************************************
' Max number of Board, Ch, Marker, Measurement points
'*****************************************************
Public Const MAX_BOARD As Long = 7                      'The max number of board. (Max = 8)
Public Const MAX_CH As Long = 3                         'The max number of CH. (Max = 4)
Public Const MAX_MARKER As Long = 11                    'The max number of marker. (Max = 12)
Public Const MAX_MEAS_POINT As Long = 1600              'The max number of measurement points. (Max = 1601)
Public Const MAX_MEMTRACE As Long = 2                   'The max number of Memory Trace. (Max = 3)
Public Const MAX_PORT As Long = 3                       'The max number of PORT. (Max = 4)
'*****************************************************
' This variable is an access variable to the board.
'*****************************************************
Public NaPID(0 To MAX_BOARD) As Long                    'Variable that puts in Open ID(BisOpenPacket) of each board.
Public BdId As Long                                     'Board No. 0 to MAX_BOARD
Public lngExpSwBox As Long                              'Read extended SW-BOX type
Public strExpSwBoxType As String                        'Read extended SW-BOX type
'*****************************************************
'  Grid Color Key word.
'*****************************************************
Public Const GRID_NORMAL As Integer = 0                 'Grid Color.
Public Const GRID_BOLD  As Integer = 1                  'Grid Bold Color.
Public Const MAX_GRID_COLOR As Long = 1                 'The max number of grid color.
'*****************************************************
'  Grid Color Key word.
'*****************************************************
Public Const MAX_MKR_COLOR As Long = 1                  'The max number of marker color.
'*****************************************************
'  Measurement data
'*****************************************************
Public TrcClrLogmag As Long                             'Trace Color Logmag
Public TrcClrPhase As Long                              'Trace Color Phase
Public TrcClrPolar As Long                              'Trace Color Polar
Public TrcClrSmith As Long                              'Trace Color Smith
Public TrcClrReal As Long                               'Trace Color Real
Public TrcClrImag As Long                               'Trace Color Imag
Public TrcClrDelay As Long                              'Trace Color Delay
Public TrcClrSwr As Long                                'Trace Color Swr
Public GrdClrLogmag(MAX_GRID_COLOR) As Long             'Grid Color Logmag / Phase
Public GrdClrPolar(MAX_GRID_COLOR) As Long              'Grid Color Polar
Public GrdClrSmith(MAX_GRID_COLOR) As Long              'Grid Color Smith
Public GrdClrReal(MAX_GRID_COLOR) As Long               'Grid Color Real
Public GrdClrImag(MAX_GRID_COLOR) As Long               'Grid Color Imag
Public GrdClrDelay(MAX_GRID_COLOR) As Long              'Grid Color Delay
Public GrdClrSwr(MAX_GRID_COLOR) As Long                'Grid Color Swr

Public MkrColor(MAX_MKR_COLOR) As Long                  'Marker Color
Public MkrClrList(MAX_MKR_COLOR) As Long                'Marker List Color

Public BufLgm(0 To MAX_MEAS_POINT) As Single            'The measurement data of logmag.
Public BufPhs(0 To MAX_MEAS_POINT) As Single            'The measurement data of phase.
Public BufLnm(0 To MAX_MEAS_POINT) As Single            'The measurement data of linearmag.
Public BufReal(0 To MAX_MEAS_POINT) As Single           'The measurement data of real.
Public BufImag(0 To MAX_MEAS_POINT) As Single           'The measurement data of imaginary.
Public BufuPhs(0 To MAX_MEAS_POINT) As Single           'The measurement data of phase-unwrap.
Public BufDelay(0 To MAX_MEAS_POINT) As Single          'The measurement data of delay.
Public BufSwr(0 To MAX_MEAS_POINT) As Single            'The measurement data of swr.
Public BufG(0 To MAX_MEAS_POINT) As Single              'The measurement data of g.
Public BufB(0 To MAX_MEAS_POINT) As Single              'The measurement data of b.
Public BufFrq(0 To MAX_MEAS_POINT) As Double            'The measurement data of frequency.
Public MinPLogmag As Integer                            'The measurement data of logmag (max point)
Public MaxPLogmag As Integer                            'The measurement data of logmag (min point)
Public DegPLogmag As Integer                            'The measurement data of logmag (0deg point)
Public MinDelay As Single                               'The measurement data of delay (max).
Public MaxDelay As Single                               'The measurement data of delay (min).
Public MinPDelay As Integer                             'The measurement data of delay (max point)
Public MaxPDelay As Integer                             'The measurement data of delay (min point)
Public MinSwr As Single                                 'The measurement data of swr (max).
Public MaxSwr As Single                                 'The measurement data of swr (min).
Public MinPSwr As Integer                               'The measurement data of swr (max point).
Public MaxPSwr As Integer                               'The measurement data of swr (min point).
Public cal1((MAX_MEAS_POINT + 1) * 2) As Single         ' Cal Data 1 (Real,Imag)
Public cal2((MAX_MEAS_POINT + 1) * 2) As Single         ' Cal Data 2 (Real,Imag)
Public cal3((MAX_MEAS_POINT + 1) * 2) As Single         ' Cal Data 3 (Real,Imag)
'*****************************************************
'  Measurement condition
'*****************************************************
Public BufSeg(0 To MAX_MEAS_POINT) As SourSeg           'Segment Sweep setting.
Public SegCnt As Long                                   'Segment Sweep setting count.
Public SwpTime As Double                                'Sweep time.
Public SwpTAt As Long                                   'Sweep time auto state.(0:OFF, 1:ON).
Public IfRbw As Single                                  'Setting of measurement RBW.
Public Aperture As Single                               'delay format aperture setting.
Public totalP As Long                                   'Setting of number of measurement points.
Public EleCorrStat As Long                              'Sets ON/OFF for the electrical length correction function.
Public EleCorrTime As Double                            'Sets electrical length correction values (time: seconds).
Public EleCorrLength As Double                          'Sets electrical length correction values (length: mm).
Public PortExtStat As Long                              'Sets ON/OFF for the Port Extension function.
Public PortExtTime As Double                            'Sets Port Extension values (time: seconds).
Public PortExtLength As Double                          'Sets Port Extension values (length: mm).
Public CorOn As Long                                    'Calibration state.
Public CorMeth As Long                                  'Calibration read type
                                                        ' BIS_CAL_NORM = 0  : Normalize
                                                        ' BIS_CAL_TRANS = 1 : Transmission full calibration
                                                        ' BIS_CAL_1PORT = 2 : 1port Full Calibration
Public TrCalMeth As Long                                'Calibration set type
                                                        ' BIS_CAL_NORM = 0  : Normalize
                                                        ' BIS_CAL_TRANS = 1 : Transmission full calibration
                                                        ' BIS_CAL_1PORT = 2 : 1port Full Calibration
Public CorAcq(0 To 3) As Long                           '1port Full Calibration (0:OPNE, 1:SHORT, 2:LOAD, 3:Done)
Public CorLoop As Long                                  'Calibration sweep flag.
Public StdCKit As structStdCKit                         'Standard Cal kit Factor
Public CKit As structCKit                               '1port Full Calibration Cal Type and Port Connect Sex Type and Port Cal Factor
Public UserCalKit As CkitUser                           'User Cal kit Factor
Public strGetCalDateTime As String                      'Get Calibration Time
'*****************************************************
'  Application variable
'*****************************************************
Public TrLgm As Long                                    'Trace number of logmag
Public TrPhs As Long                                    'Trace number of phase.
Public TrLnm As Long                                    'Trace number of linearmag.
Public TrRel As Long                                    'Trace number of real.
Public TrImg As Long                                    'Trace number of imaginary.
Public TrCa1 As Long                                    'Trace number of CAL data 1 (complex number)
Public TrCa2 As Long                                    'Trace number of CAL data 2 (complex number)
Public TrCa3 As Long                                    'Trace number of CAL data 3 (complex number)
Public ActCh(0 To MAX_BOARD) As Long                    'Active Ch.
Public FreqUnitIndex(MAX_BOARD, MAX_CH) As Integer      'CH Start/Stop/Center Unit Index No. Backup
Public SpanUnitIndex(MAX_BOARD, MAX_CH) As Integer      'CH Span Unit Index No. Backup
Public MkrUnitIndex(MAX_BOARD, MAX_CH) As Integer       'CH Marker Unit Index No. Backup
'*****************************************************
'  Sweep condition variable
'*****************************************************
Public ContFlag As Integer                              'continuance sweep
Public SnglFlag As Integer                              'single sweep
Public AborFlag As Integer                              'sweep abort
Public PortExtFlag As Integer                           'Marker Port Extension
Public ExitFlag As Long                                 'Application end
Public Mscl(MAX_BOARD, MAX_CH) As Scale_t
Public Pscl(MAX_BOARD, MAX_CH) As Scale_t
Public Dscl(MAX_BOARD, MAX_CH) As Scale_t
Public SWRscl(MAX_BOARD, MAX_CH) As Scale_t
Public Rscl(MAX_BOARD, MAX_CH) As Scale_t
Public Iscl(MAX_BOARD, MAX_CH) As Scale_t
Public PartSweep(MAX_BOARD, MAX_CH) As Integer
Public PartStPoint(MAX_BOARD, MAX_CH) As Integer
Public PartSpPoint(MAX_BOARD, MAX_CH) As Integer
Public ChkPhs(MAX_BOARD) As Integer                     'Check Box Phase
Public ChkMkr(MAX_BOARD) As Integer                     'Check Box Marker

Public ActMkr As Integer                                'Active Marker No.
Public ChMkrInf(MAX_BOARD, MAX_CH) As structMkrChInf    'Display Total Maker Count and Active Marker No.
Public Marker(MAX_BOARD, MAX_CH, MAX_MARKER) As structMkrInf    'Marker(Board, CH, Marker)

Public NA_ProductName As String
Public NA_ConnectProductName As String
Public NA_SerialNumber As String

'*****************************************************
Public FileDlg As New FileDlg
Public strPathFileAtt As String
Public strBmpPathFileAtt As String
Public strXtalPathFileAtt As String

Public RdDispFromatTab As Integer                       ' Recall Display format tab No.
Public RdDispMarkerMax As Integer                       ' Recall Display marker No.
Public RdActMkr As Integer                              ' Active Marker No.
Public RdMeas As Long                                   ' Measure (R,A,A/R,S11,S21)
Public RdOverlapMkrFormat As Long                       ' Marker Overlap display format
Public RdSavedDtType As Long                            ' The saved valid data type
Public RdCorOn As Long                                   'The saved Calibration state.

Public intFileSave As Integer                           ' Saving = 1, Not Saving = 0
Public intFileRecall As Integer                         ' Recall = 1, Not Recall = 0
Public intSweepStatus As Integer                        ' normal_onesweep start = 1 , normal_onesweep end = 0

'*****************************************************
'  Memory Trace information on each channel
'*****************************************************
Public Type structMemTraceChInf
    'LogMag
    MemTrcBufLgm(0 To MAX_MEAS_POINT) As Single         'The trace data of logmag is saved in a memory.
    MemTrcBufPhs(0 To MAX_MEAS_POINT) As Single         'The trace data of phase is saved in a memory.
    MemTrcBufLnm(0 To MAX_MEAS_POINT) As Single         'The trace data of linearmag is saved in a memory.
    'Polar, Smith
    MemTrcBufReal(0 To MAX_MEAS_POINT) As Single        'The trace data of real is saved in a memory.
    MemTrcBufImag(0 To MAX_MEAS_POINT) As Single        'The trace data of imaginary is saved in a memory.
    'Delay
    MemTrcBufuPhs(0 To MAX_MEAS_POINT) As Single        'The trace data of phase-unwrap is saved in a memory.
    MemTrcBufDelay(0 To MAX_MEAS_POINT) As Single       'The trace data of delay is saved in a memory.
    'SWR
    MemTrcBufSwr(0 To MAX_MEAS_POINT) As Single         'The trace data of swr is saved in a memory.
    'LogMag
    MemTrcLgmCol As Long                                'The trace of logmag is color.
    MemTrcPhsCol As Long                                'The trace of phase is color.
    'Polar, Smith
    MemTrcPolarCol As Long                              'The trace of Polar is color.
    MemTrcSmithCol As Long                              'The trace of Smith is color.
    'Polar, Smith
    MemTrcRealCol As Long                               'The trace of real is color.
    MemTrcImagCol As Long                               'The trace of imaginary is color.
    'Delay
    MemTrcDelayCol As Long                              'The trace of delay is color.
    'SWR
    MemTrcSwrCol As Long                                'The trace of swr is color.
End Type
'*****************************************************
'  Memory Trace Save condition struct
'*****************************************************
Public Type structMemTrcInf
    MemTrcActive   As Integer                           'Currently Memory Trace Active No.
    MemTrcTotalDispFlag As Integer                      'Memory Trace Total Display Flag.
    MemTrcSaveFlag(0 To MAX_MEMTRACE) As Integer        'Memory Trace Save Flag.
    MemTrcDispFlag(0 To MAX_MEMTRACE) As Integer        'Memory Trace Screen Display Flag.
End Type
'*****************************************************
'  Compensate Setting struct
'*****************************************************
Public Type structCompensate
    CmpsFlag As Integer         'Currently Marker Compensate Flag.(local)
    CmpsZeroSpn As Integer      'Currently Zero Span Status.
End Type
'*****************************************************
'  Memory Trace Conrol variable
'*****************************************************
Public MemTrcFlag As Integer                            'Active Memory Trace Save Flag
Public ActMemTrc As Integer                             'Active Memory Trace No.
Public ChMemTrcInf(MAX_BOARD, MAX_CH, MAX_MEMTRACE) As structMemTraceChInf
Public MemTrcDispInf(MAX_BOARD, MAX_CH) As structMemTrcInf
Public CmdBtnDwnFlag As Integer
Public CmpsInf(MAX_BOARD, MAX_CH) As structCompensate
'*****************************************************
'@Extended SW-BOX type(SP4T A170009)
'*****************************************************
Public SP4TPort(MAX_BOARD, MAX_CH) As Long              'Active Port No. (SP4T A170009)
Public DPDTPort(MAX_BOARD, MAX_CH) As Long              'Active Port No. (DPDT A170010)


'********
'  Preset
'********
Public blnPreset As Boolean                             'Preset status. False : No Preset, True : Preset

'********
'  Xtal
'********
Public Const MAX_XTAL_ITEM As Long = 2                  ' The max number of Xtal measurement item
Public Const XTAL_ITEM_FR As Integer = 0                ' FR search
Public Const XTAL_ITEM_EQU As Integer = 1               ' Equivalent constants
Public Const XTAL_ITEM_FL  As Integer = 2               ' FL measurement

Public Const MAX_XTAL_MEAS As Long = 4                  ' The max number of Xtal measurement condition
Public Const XTAL_C0 As Integer = 0                     ' C0
Public Const XTAL_OTHER As Integer = 1                  ' Other
Public Const XTAL_FL As Integer = 2                     ' FL
Public Const XTAL_CAL As Integer = 3                    ' CAL
Public Const XTAL_FR As Integer = 4                     ' Fr Search

Public Type structXtalMeasCondition
    dblCentFreq As Double                               ' Specifies CENTER frequency
    dblSpanFreq As Double                               ' Specifies SPAN frequency
    dblStrFreq As Double                                ' Specifies Start frequency
    dblStpFreq As Double                                ' Specifies Stop frequency
    lngStrPoint As Long                                 ' Specifies Start frequency of measurement point
    lngStpPoint As Long                                 ' Specifies Stop frequency of measurement point
    lngPoint As Long                                    ' Specifies the number of measurement points
    sngRbw As Single                                    ' Specifies RBW
    snguW As Single                                     ' Specifies output level (uW)
    sngLevel As Single                                  ' Specifies output level (dBm)
    sngStime As Single                                  ' Specifies settling time
End Type

Public Type structXtalEquConstants                      ' Equivalent constants
    dblC0 As Double                                     ' C0:Equivalent parallel capacitance
    dblC1 As Double                                     ' C1:Equivalent series capacitance
    dblL1 As Double                                     ' L1:Equivalent series inductance
    dblR1 As Double                                     ' R1:Equivalent series resistance
    dblQ As Double                                      ' Q :Quality factor
    dblCi As Double                                     ' CI:Crystal impedance
    dblFr As Double                                     ' fr:Resonant frequency (phase 0 degree):
    dblFs As Double                                     ' fs:Series resonant frequency (Gmax)
    dblFl As Double                                     ' fl:Series Load resonance frequency
End Type

Public Type structXtalMeas
    lngCounter As Long                                  'Measurement Count
    strSvFileN As String                                'Logging File Name
    dblNomFreq As Double                                'Nominal frequency
    dblLoadCap As Double                                'Load capacitance
    dblTypicalCI As Double                              'Typical CI [ohm]
    intMeasItem(MAX_XTAL_ITEM) As Integer               'Measurement item.(0:Fr search, 1:Equivalent constants, 2:FL measurement)
    condition(MAX_XTAL_MEAS) As structXtalMeasCondition 'Measurement condition.(0:C0, 1:Other, 2:FL measurement)
    calCorrect As structStdCKit                         'Cal Kit Correction
    result As structXtalEquConstants                    'Measurement result
    blnUpJudge As Boolean                               'Upper Limit True : Valid, False : Invalid
    Up_limit As structXtalEquConstants                  'Upper Limit
    blnLwJudge As Boolean                               'Lower Limit True : Valid, False : Invalid
    Lw_limit As structXtalEquConstants                  'Lower Limit
'    XtalSwpTime As Double                               'Sweep time.
End Type

Public Type structProductFreq                           ' Product frequency
    dblMin As Double                                    ' Min frequency
    dblMax As Double                                    ' Max frequency
End Type

Public XtalBufSeg(0 To MAX_XTAL_MEAS) As SourSeg        'Xtal Cal Segment Sweep setting.
Public XtalSegCnt As Long                               'Xtal Cal Segment Count.
Public XtalMeas As structXtalMeas                       'Xtal Measurement
Public XtalCKit As structStdCKit                        'Xtal Cal kit Factor
Public XtalMeasChg As Integer
Public XtalCalPoint As Long                             'Xtal Calibration points
Public XtalFreqLmt(MAX_BOARD) As structProductFreq      'Xtal frequency Limit
Public XtalImpedance As Double                          'Xtal Impedance
Public XtalProfitofAmp As Double                        'Xtal proit of amp.
